<?php
/**
*
* @package phpBB3
* @version $Id: functions_helpmod.php Quba $
* @copyright (c) 2008 Quba (phpBBhelp.pl)
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

/**
*
* Klasa modułu do obsługi pochwał, czyli wyróżnień
* wystawianych przez użytkowników za pomoc.
*
*/
class helpmod
{
	/**
	Funkcja pokazuje listę pochwał danego użytkownika z podziałem na strony
	*/
	function show_list($uid)
	{
		global $auth, $db, $user, $template, $phpEx, $phpbb_root_path;

		if( empty($uid) )
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['NO_USER_ID'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}

		if( !$auth->acl_get('u_help_view') )
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['VIEW_DISALLOWED'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}
		
		$default_key = 'b';
		$start	= request_var('start', 0);

		$check_params = array(
			'u'			=> array('u', $uid),
			'sk'			=> array('sk', $default_key),
			'sd'			=> array('sd', 'a')
		);

		$sort_key = request_var('sk', $default_key);
		$sort_dir = request_var('sd', 'a');

		$params[] = "mode=view";
		$sort_params[] = "mode=view";

		foreach ($check_params as $key => $call)
		{
			if (!isset($_REQUEST[$key]))
			{
				continue;
			}

			$param = call_user_func_array('request_var', $call);
			$param = urlencode($key) . '=' . ((is_string($param)) ? urlencode($param) : $param);
			$params[] = $param;

			if ($key != 'sk' && $key != 'sd')
			{
				$sort_params[] = $param;
			}
		}
		
		$sort_key_sql = array('a' => 'h.help_id', 'b' => 'help_count');
		$pagination_url = append_sid("{$phpbb_root_path}help.$phpEx", implode('&amp;', $params));
		$sort_url = append_sid("{$phpbb_root_path}help.$phpEx", implode('&amp;', $sort_params));

		if (!isset($sort_key_sql[$sort_key]))
		{
			$sort_key = $default_key;
		}

		$order_by = $sort_key_sql[$sort_key] . ' ' . (($sort_dir == 'a') ? 'DESC' : 'ASC');

		$sql = 'SELECT COUNT(help_id) AS total_helps, COUNT(DISTINCT topic_id) AS total_uhelps
			FROM ' . HELPMOD_TABLE . '
			  WHERE help_to=' . $uid;

		$result = $db->sql_query($sql);
		$row = $db->sql_fetchrow($result);
		$total_uhelps = $row['total_uhelps'];
		$total_helps = $row['total_helps'];
		$db->sql_freeresult($result);

		if ($total_helps == 0)
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['NO_HELPS'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}

		$sql = 'SELECT user_id, username, user_colour 
			FROM ' . USERS_TABLE .' WHERE user_id=' . $uid;

		$result = $db->sql_query($sql);
		$row = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		page_header($user->lang['HELP_LIST'] . ' ' . $row['username']);

		$template->assign_vars(array(
			'USERNAME' => get_username_string('full', $row['user_id'], $row['username'], $row['user_colour']),
			'PAGINATION'	=> generate_pagination($pagination_url, $total_uhelps, 20, $start),
			'PAGE_NUMBER'	=> on_page($total_uhelps, 20, $start),
			'U_SORT_TIME'			=> $sort_url . '&amp;sk=a&amp;sd=' . (($sort_key == 'a' && $sort_dir == 'a') ? 'd' : 'a'),
			'U_SORT_COUNT'			=> $sort_url . '&amp;sk=b&amp;sd=' . (($sort_key == 'b' && $sort_dir == 'a') ? 'd' : 'a'),
			'DELETE_LINK'			=> $auth->acl_gets('a_help_delete', 'm_help_delete') ? true : false,
			'COUNT' 			=> true)
		 );

		
		$sql = $db->sql_build_query('SELECT', array(
			'SELECT'	=> 'h.*, h.topic_id, t.topic_title, count(h.help_id) as help_count',
			'FROM'		=> array(HELPMOD_TABLE => 'h'),
			'LEFT_JOIN' => array(
				array(
					'FROM'	=> array(TOPICS_TABLE => 't'),
					'ON'	=> 't.topic_id = h.topic_id',
				),
			),
			'GROUP_BY'	=> 'h.topic_id',
			'WHERE'		=> 'h.help_to = ' . $uid,
			'ORDER_BY'	=> $order_by,
		));

		$result = $db->sql_query_limit($sql, 20, $start);

		while ($row = $db->sql_fetchrow($result))
		{
			$title = ( empty($row['topic_title']) ) ? '<strong>Temat usunięty</strong>' : $row['topic_title'];
			$title_link = ( !empty($row['topic_title']) ) ? '<a href="viewtopic.' . $phpEx . '?t=' . $row['topic_id'] . '">' . $title . '</a>' : $title;

			$topic = $title_link . ' (<a href="help.' . $phpEx . '?mode=details&t=' . $row['topic_id'] . '&amp;u=' . $uid . '">' . $user->lang['DETAILS'] . '</a>)';
			$help_count = $row['help_count'];
			$time = $user->format_date($row['help_time']);
			$delete_link = false;
			  
			if( $auth->acl_gets('a_help_delete', 'm_help_delete') ) $delete_link = '<a href="help.' . $phpEx . '?mode=delete&amp;t=' . $row['topic_id'] . '&amp;u=' .$uid . '">' . $user->lang['DELETE'] . '</a>';
			
			$template->assign_block_vars('helplist', array(
				'TOPICTITLE'    		=> $topic,
				'TIME'				=> $time,
				'COUNT' 			=> '<strong>' . $help_count . '</strong> (' . number_format($help_count/$total_helps * 100, 0) . '%)',
				'DELETE' 			=> $delete_link)
			);
		}

	}

	function show_details($topic_id, $uid)
	{
		global $auth, $db, $user, $template, $phpEx, $phpbb_root_path;

		if( !isset($topic_id) )
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['NO_TOPIC_ID'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}

		if( empty($uid) )
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['NO_USER_ID'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}

		if( !$auth->acl_get('u_help_view') )
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['VIEW_DISALLOWED'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}
		
		$default_key = 'c';
		$start	= request_var('start', 0);

		$check_params = array(
			'u'			=> array('u', $uid),
			't'			=> array('t', $topic_id),
			'sk'			=> array('sk', $default_key),
			'sd'			=> array('sd', 'a')
		);

		$sort_key = request_var('sk', $default_key);
		$sort_dir = request_var('sd', 'a');

		$params[] = "mode=details";
		$sort_params[] = "mode=details";

		foreach ($check_params as $key => $call)
		{
			if (!isset($_REQUEST[$key]))
			{
				continue;
			}

			$param = call_user_func_array('request_var', $call);
			$param = urlencode($key) . '=' . ((is_string($param)) ? urlencode($param) : $param);
			$params[] = $param;

			if ($key != 'sk' && $key != 'sd')
			{
				$sort_params[] = $param;
			}
		}
		
		$sort_key_sql = array('a' => 'u.username_clean', 'b' => 'h.help_id', 'c' => 'h.post_id');
		$pagination_url = append_sid("{$phpbb_root_path}help.$phpEx", implode('&amp;', $params));
		$sort_url = append_sid("{$phpbb_root_path}help.$phpEx", implode('&amp;', $sort_params));

		if (!isset($sort_key_sql[$sort_key]))
		{
			$sort_key = $default_ke;
		}

		$order_by = $sort_key_sql[$sort_key] . ' ' . (($sort_dir == 'a') ? 'ASC' : 'DESC');

		$sql = 'SELECT COUNT(help_id) AS total_helps
			FROM ' . HELPMOD_TABLE . ' h
			WHERE topic_id=' . $topic_id . '
				AND h.help_to=' . $uid;

		$result = $db->sql_query($sql);
		$total_helps = (int) $db->sql_fetchfield('total_helps');
		$db->sql_freeresult($result);

		if ($total_helps == 0)
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['NO_HELPS'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}

		$sql = 'SELECT user_id, username, user_colour 
			FROM ' . USERS_TABLE .' WHERE user_id=' . $uid;

		$result = $db->sql_query($sql);
		$row = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		page_header($user->lang['HELP_LIST'] . ' ' . $row['username']);    

		$template->assign_vars(array(
			'USERNAME' => get_username_string('full', $row['user_id'], $row['username'], $row['user_colour']),
			'PAGINATION'	=> generate_pagination($pagination_url, $total_helps, 20, $start),
			'PAGE_NUMBER'	=> on_page($total_helps, 10, $start),
			'U_SORT_USERNAME'		=> $sort_url . '&amp;sk=a&amp;sd=' . (($sort_key == 'a' && $sort_dir == 'd') ? 'a' : 'd'),
			'U_SORT_TIME'			=> $sort_url . '&amp;sk=b&amp;sd=' . (($sort_key == 'b' && $sort_dir == 'd') ? 'a' : 'd'),
			'U_SORT_POSTS'			=> $sort_url . '&amp;sk=c&amp;sd=' . (($sort_key == 'c' && $sort_dir == 'd') ? 'a' : 'd'),
			'DELETE_LINK'			=> $auth->acl_gets('a_help_delete', 'm_help_delete') ? true : false,
			'REASON'			=> true,
			'USER'				=> true)
		 );

		
		$sql = $db->sql_build_query('SELECT', array(
			'SELECT'	=> 'u.username, u.user_colour, u.user_helps, h.*, t.topic_title',
			'FROM'		=> array(HELPMOD_TABLE => 'h'),
			'LEFT_JOIN' => array(
				array(
					'FROM'	=> array(USERS_TABLE => 'u'),
					'ON'	=> 'h.help_from = u.user_id',
				),
				array(
					'FROM'	=> array(TOPICS_TABLE => 't'),
					'ON'	=> 't.topic_id = h.topic_id',
				),
			),
			'WHERE'		=> 'h.topic_id = ' . $topic_id . ' AND h.help_to = ' . $uid,
			'ORDER_BY'	=> $order_by . ', h.help_id ASC',
		));

		$result = $db->sql_query_limit($sql, 20, $start);

		while ($row = $db->sql_fetchrow($result))
		{
			$topic = ( !empty($row['topic_title']) ) ? '<a href="viewtopic.' . $phpEx . '?p=' . $row['post_id'] . '#p' . $row['post_id'] . '">' . $row['topic_title'] . ' #p' . $row['post_id'] . '</a>' : '<strong>Post usunięty</strong>';
			$reason = (!empty($row['help_reason'])) ? $row['help_reason'] : $user->lang['NONE'];
			$time = $user->format_date($row['help_time']);
			$user_from = get_username_string('full', $row['help_from'], $row['username'], $row['user_colour']);
			$delete_link = false;
			  
			if( $auth->acl_gets('a_help_delete', 'm_help_delete') ) $delete_link = '<a href="help.' . $phpEx . '?mode=delete&amp;id=' . $row['help_id'] . '&amp;u=' .$uid . '">' . $user->lang['DELETE'] . '</a>';
			
			$template->assign_block_vars('helplist', array(
				'TOPICTITLE'    		=> $topic,
				'REASON' 			=> $reason,
				'TIME'				=> $time,
				'USERNAME'  			=> $user_from,
				'DELETE' 			=> $delete_link)
			);
		}

	}
	
	function show_postdetails($post_id)
	{
		global $auth, $db, $user, $template, $phpEx, $phpbb_root_path;

		if( empty($post_id) )
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['NO_POST_ID'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}

		if( !$auth->acl_get('u_help_view') )
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['VIEW_DISALLOWED'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}
		
		$default_key = 'c';
		$start	= request_var('start', 0);

		$check_params = array(
			'sk'			=> array('sk', $default_key),
			'sd'			=> array('sd', 'a')
		);

		$sort_key = request_var('sk', $default_key);
		$sort_dir = request_var('sd', 'a');

		$params[] = "mode=postdetails";
		$sort_params[] = "mode=postdetails";

		foreach ($check_params as $key => $call)
		{
			if (!isset($_REQUEST[$key]))
			{
				continue;
			}

			$param = call_user_func_array('request_var', $call);
			$param = urlencode($key) . '=' . ((is_string($param)) ? urlencode($param) : $param);
			$params[] = $param;

			if ($key != 'sk' && $key != 'sd')
			{
				$sort_params[] = $param;
			}
		}
		
		$sort_key_sql = array('a' => 'u.username_clean', 'b' => 'h.help_id', 'c' => 'h.post_id');
		$pagination_url = append_sid("{$phpbb_root_path}help.$phpEx", implode('&amp;', $params));
		$sort_url = append_sid("{$phpbb_root_path}help.$phpEx", implode('&amp;', $sort_params));

		if (!isset($sort_key_sql[$sort_key]))
		{
			$sort_key = $default_ke;
		}

		$order_by = $sort_key_sql[$sort_key] . ' ' . (($sort_dir == 'a') ? 'ASC' : 'DESC');

		$sql = 'SELECT COUNT(help_id) AS total_helps
			FROM ' . HELPMOD_TABLE . '
				WHERE post_id=' . $post_id;

		$result = $db->sql_query($sql);
		$total_helps = (int) $db->sql_fetchfield('total_helps');
		$db->sql_freeresult($result);

		if ($total_helps == 0)
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['NO_HELPS'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}
		
		$sql = $db->sql_build_query('SELECT', array(
			'SELECT'	=> 'u.username, u.user_colour, u.user_helps, h.*, t.topic_title',
			'FROM'		=> array(HELPMOD_TABLE => 'h'),
			'LEFT_JOIN' => array(
				array(
					'FROM'	=> array(USERS_TABLE => 'u'),
					'ON'	=> 'h.help_from = u.user_id',
				),
				array(
					'FROM'	=> array(TOPICS_TABLE => 't'),
					'ON'	=> 't.topic_id = h.topic_id',
				),
			),
			'WHERE'		=> 'h.post_id = ' . $post_id,
			'ORDER_BY'	=> $order_by . ', h.help_id ASC',
		));

		$result = $db->sql_query_limit($sql, 20, $start);

		while ($row = $db->sql_fetchrow($result))
		{
			$userid_to = $row['help_to'];
			$topic = ( !empty($row['topic_title']) ) ? '<a href="viewtopic.' . $phpEx . '?p=' . $row['post_id'] . '#p' . $row['post_id'] . '">' . $row['topic_title'] . ' #p' . $row['post_id'] . '</a>' : '<strong>Post usunięty</strong>';
			$reason = (!empty($row['help_reason'])) ? $row['help_reason'] : $user->lang['NONE'];
			$time = $user->format_date($row['help_time']);
			$user_from = get_username_string('full', $row['help_from'], $row['username'], $row['user_colour']);
			$delete_link = false;
			  
			if( $auth->acl_gets('a_help_delete', 'm_help_delete') ) $delete_link = '<a href="help.' . $phpEx . '?mode=delete&amp;id=' . $row['help_id'] . '&amp;u=' .$row['help_to'] . '">' . $user->lang['DELETE'] . '</a>';
			
			$template->assign_block_vars('helplist', array(
				'TOPICTITLE'    		=> $topic,
				'REASON' 			=> $reason,
				'TIME'				=> $time,
				'USERNAME'  			=> $user_from,
				'DELETE' 			=> $delete_link)
			);
		}

		$sql = 'SELECT user_id, username, user_colour 
			FROM ' . USERS_TABLE .' WHERE user_id=' . $userid_to;

		$result = $db->sql_query($sql);
		$row = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		page_header($user->lang['HELP_LIST'] . ' ' . $row['username'] . ' dla postu numer ' . $post_id);       

		$template->assign_vars(array(
			'USERNAME' => get_username_string('full', $row['user_id'], $row['username'], $row['user_colour']),
			'POST_ID' => 	$post_id,
			'PAGINATION'	=> generate_pagination($pagination_url, $total_helps, 10, $start),
			'PAGE_NUMBER'	=> on_page($total_helps, 20, $start),
			'U_SORT_USERNAME'		=> $sort_url . '&amp;sk=a&amp;sd=' . (($sort_key == 'a' && $sort_dir == 'd') ? 'a' : 'd'),
			'U_SORT_TIME'			=> $sort_url . '&amp;sk=b&amp;sd=' . (($sort_key == 'b' && $sort_dir == 'd') ? 'a' : 'd'),
			'U_SORT_POSTS'			=> $sort_url . '&amp;sk=c&amp;sd=' . (($sort_key == 'c' && $sort_dir == 'd') ? 'a' : 'd'),
			'DELETE_LINK'			=> $auth->acl_gets('a_help_delete', 'm_help_delete') ? true : false,
			'REASON'			=> true,
			'USER'				=> true)
		 );

	}

	function handle_point_add($post_id)
	{
		global $user, $db, $auth;
		global $phpbb_root_path, $phpEx, $s_hidden_fields;

		if( empty($post_id) )
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['NO_POST_ID'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}

		// Jeśli ma się odpowiednie zezwolenia, wyświetli stronę potwierdzenia
		if ($auth->acl_gets('u_help_add', 'm_help_add', 'a_help_add') )
		{
			if ($this->confirm_help_box(true))
			{
				$username = request_var('username', '');
				$topic_id = request_var('topic_id', '');
				$notify = request_var('notify_user', '');
				$post_id = request_var('p', 0);
				$forum_id = request_var('f', 0);
				$reason = utf8_normalize_nfc(request_var('reason', '', true));
				$uid = request_var('help_to', '');
				
				if ($this->add($uid, $post_id, $topic_id, $reason, $notify))
				{
					$meta_info = append_sid("{$phpbb_root_path}viewtopic.$phpEx", "p=$post_id#p$post_id");
					$message = $user->lang['POINT_ADDED'] . '<br /><br />' . sprintf($user->lang['RETURN_TOPIC'], '<a href="' . append_sid("{$phpbb_root_path}viewtopic.$phpEx", "p=$post_id") . '">', '</a>');
	
					add_log('mod', $forum_id, $topic_id, 'LOG_USER_HELP', $username);
					meta_refresh(3, $meta_info);
					trigger_error($message);
				}
			}
			else
			{
				$this->confirm_help_box(false, 'ADD_POINT', $s_hidden_fields);
			}
		}
		
		$message = $user->lang['USER_CANNOT_ADD_HELP'] . '<br /><br />' . sprintf($user->lang['RETURN_POINTLIST'], '<a href="' . append_sid("{$phpbb_root_path}help.$phpEx", "mode=view&amp;u=$uid") . '">', '</a>');

		trigger_error($message);
	}
	
	function add($uid, $post_id, $topic_id, $reason, $notify = false)
	{
		global $phpEx, $phpbb_root_path, $config;
		global $template, $db, $user, $auth;
		
		if ($notify)
		{
			include_once($phpbb_root_path . 'includes/functions_privmsgs.' . $phpEx);
			include_once($phpbb_root_path . 'includes/message_parser.' . $phpEx);
		
			$message_parser = new parse_message();
		
			$post_url = append_sid("{$phpbb_root_path}viewtopic.$phpEx", "p=$post_id");
			$post_link = '<a href="' . $post_url . '">';

			if (!empty($reason))
			{
				$message_parser->message = sprintf($user->lang['HELP_PM_BODY_REASON'], $reason, $post_link, '</a>');
			}
			else
			{	
				$message_parser->message = sprintf($user->lang['HELP_PM_BODY'], $post_link, '</a>');
			}

			$message_parser->parse(true, true, true, false, false, true, true);
	
			$pm_data = array(
				'from_user_id'			=> $user->data['user_id'],
				'from_user_ip'			=> $user->ip,
				'from_username'			=> $user->data['username'],
				'enable_sig'			=> false,
				'enable_bbcode'			=> true,
				'enable_smilies'		=> true,
				'enable_urls'			=> false,
				'icon_id'			=> 0,
				'bbcode_bitfield'		=> $message_parser->bbcode_bitfield,
				'bbcode_uid'			=> $message_parser->bbcode_uid,
				'message'			=> $message_parser->message,
				'address_list'			=> array('u' => array($uid => 'to')),
			);
	
			submit_pm('post', $user->lang['HELP_PM_SUBJECT'], $pm_data, false);
		}
		
		$sql_ary = array(
			'post_id'		=> $post_id,
			'topic_id'		=> $topic_id,
			'help_time'		=> time(),
			'help_from'		=> $user->data['user_id'],
			'help_to'		=> $uid,
			'help_reason'		=> $reason
		);
		
		$db->sql_query('INSERT INTO ' . HELPMOD_TABLE . ' ' . $db->sql_build_array('INSERT', $sql_ary));
		
		$sql = 'UPDATE ' . USERS_TABLE . '
			SET user_helps = user_helps + 1 
			WHERE user_id = ' . $uid;
		$db->sql_query($sql);

		$sql = "SELECT post_help_users FROM " . POSTS_TABLE . " WHERE post_id = " . $post_id;
		$result = $db->sql_query($sql);
		$users = $db->sql_fetchfield('post_help_users');
		$db->sql_freeresult($result);
		
		if (!empty($users))
		{
			$users = explode(',', $users);
			$userid = array($user->data['user_id']);
			$users = array_merge($users, $userid);
			$users = implode(',', $users);
		}
		else
		{
			$users = (string) $user->data['user_id'];
		}

		$sql = "UPDATE " . POSTS_TABLE . "
			SET post_help_users = '$users'  
			WHERE post_id = " . $post_id;
		$db->sql_query($sql);

		return true;
	
	}

	function handle_point_delete($id = '', $topic_id = '')
	{
		global $user, $db, $auth, $uid;
		global $phpbb_root_path, $phpEx, $s_hidden_fields;

		if( empty($uid) )
		{
			$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
			$message = $user->lang['NO_USER_ID'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
			meta_refresh(3, $meta_info);
			trigger_error($message);
		}

		if( empty($id) && !isset($topic_id) )
		{
			$uid = intval(request_var('u', ''));
			$message = $user->lang['NO_ID'] . '<br /><br />' . sprintf($user->lang['RETURN_POINTLIST'], '<a href="' . append_sid("{$phpbb_root_path}help.$phpEx", "mode=view&amp;u=$uid") . '">', '</a>');
			trigger_error($message);
		}

		// Jeśli ma się odpowiednie zezwolenia, wyświetli stronę potwierdzenia
		if ($auth->acl_gets('m_help_delete', 'a_help_delete'))
		{
			$s_hidden_fields = build_hidden_fields(array(
				'id'		=> $id,
				't'		=> $topic_id,
				'uid'		=> $uid,
				'mode'		=> 'delete')
			);

			if (confirm_box(true))
			{
				if ($this->delete($id, $topic_id))
				{
					$sql = 'SELECT u.username
						FROM ' . USERS_TABLE . ' u
						WHERE u.user_id = ' . $uid;
					$result = $db->sql_query($sql);
					$user_row = $db->sql_fetchrow($result);
					$db->sql_freeresult($result);

					$meta_info = append_sid("{$phpbb_root_path}help.$phpEx", "mode=view&amp;u=$uid");
					$message = $user->lang['POINT_DELETED'] . '<br /><br />' . sprintf($user->lang['RETURN_POINTLIST'], '<a href="' . append_sid("{$phpbb_root_path}help.$phpEx", "mode=view&amp;u=$uid") . '">', '</a>');
	
					add_log('mod', '', '', 'LOG_USER_HELP_DELETE', $user_row['username']);
					meta_refresh(3, $meta_info);
					trigger_error($message);
				}
			}
			else
			{
				confirm_box(false, 'DELETE_POINT', $s_hidden_fields);
			}
		}
		
		$message = $user->lang['USER_CANNOT_DELETE'] . '<br /><br />' . sprintf($user->lang['RETURN_POINTLIST'], '<a href="' . append_sid("{$phpbb_root_path}help.$phpEx", "mode=view&amp;u=$uid") . '">', '</a>');

		trigger_error($message);
	}

	function delete($id = '', $topic_id = '')
	{
		global $auth, $db, $phpbb_root_path, $phpEx, $user, $uid;

		if ($auth->acl_gets('m_help_delete', 'a_help_delete') && empty($topic_id) && $id != 0)
		{
			$sql = "SELECT p.post_help_users, h.post_id, h.help_from, h.help_to FROM " . POSTS_TABLE . " p, " . HELPMOD_TABLE . " h 
				WHERE p.post_id = h.post_id
					AND h.help_id = $id";
			$result = $db->sql_query($sql);
			$row = $db->sql_fetchrow($result);
			$db->sql_freeresult($result);
		
			$user_from = $row['help_from'];
			$users = explode(',', $row['post_help_users']);

			foreach ($users as $userid)
			{
				if ($userid != $user_from )
				{
					$usersnew[] = $userid; 
				}
			}

			if (isset($usersnew))
			{
				$users = implode(',', $usersnew);
			}
			else
			{
				$users = '';
			}

			if (!empty($row['post_help_users']))
			{
				$sql = "UPDATE " . POSTS_TABLE . "
					SET post_help_users = '$users'  
					WHERE post_id = " . $row['post_id'];

				$db->sql_query($sql);
			}
			else
			{
				$sql = "SELECT help_to FROM " . HELPMOD_TABLE . " WHERE help_id=$id";
				$result = $db->sql_query($sql);
				$row = $db->sql_fetchrow($result);
			}

			$sql = "DELETE FROM " . HELPMOD_TABLE . " WHERE help_id = $id";
			$db->sql_query($sql);

			$sql = 'UPDATE ' . USERS_TABLE . '
			SET user_helps = user_helps - 1 
			WHERE user_id = ' . $row['help_to'];
			$db->sql_query($sql);
		}
		else if ($auth->acl_gets('m_help_delete', 'a_help_delete') && ( !empty($topic_id) || $topic_id == 0) )
		{
			$sql = "SELECT p.post_id, p.post_help_users, h.help_from, h.help_to FROM " . POSTS_TABLE . " p, " . HELPMOD_TABLE . " h 
				WHERE h.topic_id=". $topic_id . " AND h.help_to=" . $uid . " AND  p.post_id=h.post_id";
			$result = $db->sql_query($sql);

			while ($row = $db->sql_fetchrow($result))
			{
				$user_from = $row['help_from'];
				$users = explode(',', $row['post_help_users']);
				
				foreach ($users as $userid)
				{
					if ($userid != $user_from )
					{
						$usersnew[] = $userid; 
					}
				}
				if (isset($usersnew))
				{
					$users = implode(',', $usersnew);
				}
				else
				{
					$users = '';
				}

				$sql = "UPDATE " . POSTS_TABLE . "
					SET post_help_users = '$users'  
					WHERE post_id = " . $row['post_id'];
				$db->sql_query($sql); //11,7,5,4,4,5 - ,,,,, TODO

				unset($usersnew);
				unset($users);
			}

			$sql = "SELECT COUNT(help_id) AS total_helps from phpbb_helpmod
				    WHERE topic_id=". $topic_id . " AND help_to=" . $uid;
			$result = $db->sql_query($sql);
			$total_helps = (int) $db->sql_fetchfield('total_helps'); // TODO: one query
						      
			$sql = "UPDATE " . USERS_TABLE . " SET user_helps = user_helps - $total_helps 
				WHERE user_id =" . $uid;
			$db->sql_query($sql);

			$sql = "DELETE FROM " . HELPMOD_TABLE . " WHERE topic_id=$topic_id AND help_to=$uid";
			$db->sql_query($sql);
		}
		else
		{
			return false;
		}
		

		return true;
	}

	function confirm_help_box($check, $title = '', $hidden = '')
	{
		global $user, $template, $db, $config;
		global $phpEx, $phpbb_root_path, $auth;

		if (isset($_POST['cancel']))
		{
			return false;
		}

		$confirm = false;
		if (isset($_POST['confirm']))
		{
			// language frontier
			if ($_POST['confirm'] === $user->lang['YES'])
			{
				$confirm = true;
			}
		}
	
		if ($check && $confirm)
		{
			$user_id = request_var('user_id', 0);
			$session_id = request_var('sess', '');
			$confirm_key = request_var('confirm_key', '');
	
			if ($user_id != $user->data['user_id'] || $session_id != $user->session_id || !$confirm_key || !$user->data['user_last_confirm_key'] || $confirm_key != $user->data['user_last_confirm_key'])
			{
				return false;
			}
	
			// Reset user_last_confirm_key
			$sql = 'UPDATE ' . USERS_TABLE . " SET user_last_confirm_key = ''
				WHERE user_id = " . $user->data['user_id'];
			$db->sql_query($sql);

			return true;
		}
		else if ($check)
		{
			return false;
		}
	
		// generate activation key
		$confirm_key = gen_rand_string(10);
	
		page_header((!isset($user->lang[$title])) ? $user->lang['CONFIRM'] : $user->lang[$title]);
	
	
		$template->set_filenames(array(
			'body' => 'confirm_help_body.html')
		);
	
		if (request_var('confirm_key', ''))
		{
			return false;
		}
	
		$post_id = request_var('p', 0);
		$use_page = $phpbb_root_path . str_replace('&', '&amp;', $user->page['page']);
		$u_action = reapply_sid($use_page);
		$u_action .= ((strpos($u_action, '?') === false) ? '?' : '&amp;') . 'confirm_key=' . $confirm_key;
	
		$sql = 'SELECT u.*, p.*, t.*
			FROM ' . POSTS_TABLE . ' p, ' . USERS_TABLE . ' u, ' . TOPICS_TABLE . " t
			WHERE post_id = $post_id
				AND u.user_id = p.poster_id
				AND p.topic_id=t.topic_id";
		$result = $db->sql_query($sql);
		$user_row = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		if (!$user_row)
		{
			trigger_error('NO_POST');
		}

		if ($user_row['user_type'] == USER_IGNORE)
		{
			trigger_error('CANNOT_POINT_ANONYMOUS');
		}

		if ($user_row['user_id'] == $user->data['user_id'])
		{
			trigger_error('CANNOT_WARN_SELF');
		}

		$helps = explode(',', $user_row['post_help_users']);

		if ( in_array($user->data['user_id'], $helps) )
		{
			trigger_error('DOUBLE_HELP');
		}

		if ($auth->acl_get('f_help_postauthoronly', $user_row['forum_id']) && $user_row['topic_poster'] != $user->data['user_id'])
		{
			trigger_error('POSTAUTHOR_ONLY');
		}

		if (!$auth->acl_get('f_help_add', $user_row['forum_id']))
		{
			trigger_error($user->lang['USER_CANNOT_ADD_HELP']);
		}

		$user_id = $user_row['user_id'];

		
		// We want to make the message available here as a reminder
		// Parse the message and subject
		$message = (strlen($user_row['post_text']) > 1000)  ? substr($user_row['post_text'], 0, 1000) . '...' : $user_row['post_text'];
		$message = censor_text($message);

		// Second parse bbcode here
		if ($user_row['bbcode_bitfield'])
		{
			include_once($phpbb_root_path . 'includes/bbcode.' . $phpEx);

			$bbcode = new bbcode($user_row['bbcode_bitfield']);
			$bbcode->bbcode_second_pass($message, $user_row['bbcode_uid'], $user_row['bbcode_bitfield']);
		}

		$message = bbcode_nl2br($message);
		$message = smiley_text($message);

		if (!function_exists('get_user_avatar'))
		{
			include($phpbb_root_path . 'includes/functions_display.' . $phpEx);
		}

		$rank_title = $rank_img = '';
		$avatar_img = get_user_avatar($user_row['user_avatar'], $user_row['user_avatar_type'], $user_row['user_avatar_width'], $user_row['user_avatar_height']);
		
		$s_hidden_fields = build_hidden_fields(array(
			'p'		=> $post_id,
			'mode'		=> 'add',
			'user_id'	=> $user->data['user_id'],
			'username'      => $user_row['username'],
			'help_to'      	=> $user_row['user_id'],
			'topic_id'      => $user_row['topic_id'],
			'forum_id'	=> $user_row['forum_id'],
			'sess'		=> $user->session_id)
		);

		$template->assign_vars(array(
			'S_CONFIRM_ACTION'	=> $u_action,

			'POST'				=> $message,
			'USERNAME'			=> $user_row['username'],
			'USER_COLOR'			=> (!empty($user_row['user_colour'])) ? $user_row['user_colour'] : '',
			'RANK_TITLE'			=> $rank_title,
			'JOINED'			=> $user->format_date($user_row['user_regdate']),
			'POSTS'				=> ($user_row['user_posts']) ? $user_row['user_posts'] : 0,
			'WARNINGS'			=> ($user_row['user_warnings']) ? $user_row['user_warnings'] : 0,
			'HELPS'				=> ($user_row['user_helps']) ? $user_row['user_helps'] : 0,
			'AVATAR_IMG'			=> $avatar_img,
			'RANK_IMG'			=> $rank_img,
			'MESSAGE_TITLE'		=> (!isset($user->lang[$title])) ? $user->lang['CONFIRM'] : $user->lang[$title],
			'MESSAGE_TEXT'		=> (!isset($user->lang[$title . '_CONFIRM'])) ? $title : $user->lang[$title . '_CONFIRM'],
	
			'YES_VALUE'			=> $user->lang['YES'],
			'S_CONFIRM_ACTION'	=> $u_action,
			'S_HIDDEN_FIELDS'	=> $hidden . $s_hidden_fields)
		);
	
		$sql = 'UPDATE ' . USERS_TABLE . " SET user_last_confirm_key = '" . $db->sql_escape($confirm_key) . "'
			WHERE user_id = " . $user->data['user_id'];
		$db->sql_query($sql);
	
		page_footer();
	}

	function auth($post_help_users, $poster_id, $forum_id, $first_poster)
	{
		global $auth, $user;

		if ($auth->acl_get('f_help_add', $forum_id) && $user->data['user_id'] != $poster_id && $poster_id != ANONYMOUS)
		{
			if (!$auth->acl_get('f_help_postauthoronly', $forum_id) || $first_poster == $user->data['username'])
			{
				$helps = explode(',', $post_help_users);
	
				if ( !in_array($user->data['user_id'], $helps) )
				{
					return true;
				}
				else
				{
					return false;
				}
			}
		}
	}
    
}

?>