<?php
/**
*
* @author Quba (Jakub Bomba) quba@quba.info
* @package umil
* @version $Id helpmod_install.php 1.0.0 2010-02-22 22:17:37GMT Quba $
* @copyright (c) 2010 phpBBhelp.pl
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/
define('UMIL_AUTO', true);
define('IN_PHPBB', true);
$phpbb_root_path = (defined('PHPBB_ROOT_PATH')) ? PHPBB_ROOT_PATH : './';
$phpEx = substr(strrchr(__FILE__, '.'), 1);
include($phpbb_root_path . 'common.' . $phpEx);
$user->session_begin();
$auth->acl($user->data);
$user->setup();


if (!file_exists($phpbb_root_path . 'umil/umil_auto.' . $phpEx))
{
	trigger_error('Please download the latest UMIL (Unified MOD Install Library) from: <a href="http://www.phpbb.com/mods/umil/">phpBB.com/mods/umil</a>', E_USER_ERROR);
}


// The name of the mod to be displayed during installation.
$mod_name = 'HelpMod';

/*
* The name of the config variable which will hold the currently installed version
* You do not need to set this yourself, UMIL will handle setting and updating the version itself.
*/
$version_config_name = 'helpmod_version';

/*
* The array of versions and actions within each.
* You do not need to order it a specific way (it will be sorted automatically), however, you must enter every version, even if no actions are done for it.
*
* You must use correct version numbering.  Unless you know exactly what you can use, only use X.X.X (replacing X with an integer).
* The version numbering must otherwise be compatible with the version_compare function - http://php.net/manual/en/function.version-compare.php
*/
$versions = array(
	// Version 1.0.0
	'1.0.0'	=> array(
	
		// Lets add a config setting and set it to true
		'config_add' => array(
			array('helpmod_enable', true),
		),


		
		'table_column_add' => array(
			array($table_prefix . 'posts', 'post_help_users', array('VCHAR', '0')),
			array($table_prefix . 'users', 'user_helps', array('TINT:4', '0')),
		),
		
		// Now to add some tables
		'table_add' => array(
			array($table_prefix . 'helpmod', array(
					'COLUMNS'		=> array(
						'help_id'		    => array('UINT:8', NULL, 'auto_increment'),
						'post_id'			=> array('UINT:8', '0'),
						'topic_id'			=> array('UINT:8', '0'),
						'help_time'			=> array('TIMESTAMP', '0'),
						'help_from'     	=> array('UINT:8', '0'),
						'help_to'		    => array('UINT:8', '0'),
						'help_reason'	    => array('VCHAR', 'NULL'),
					),
					'PRIMARY_KEY'	=> 'help_id',
					'KEYS'		=> array(
						'' => array('PRIMARY', array('help_id')),
						'' => array('INDEX', array('help_time')),
								),
				),
			),			
		),		

		
		// Now to add some permission settings
		'permission_add' => array(
			array('u_help_add', 1),
			array('u_help_view', 1),
			array('m_help_delete', 1),
			array('a_help_delete', 1),
			array('f_help_add', 0),
			array('f_help_postauthoronly', 0),
		),

		// How about we give some default permissions then as well?
		// Admins can do anything with the helpmod
		'permission_set' => array(
			// Global Group permissions
			array('ADMINISTRATORS', 'u_help_add', 'group'),
			array('ADMINISTRATORS', 'u_help_view', 'group'),
			array('ADMINISTRATORS', 'm_help_delete', 'group'),
			array('ADMINISTRATORS', 'a_help_delete', 'group'),
			array('ADMINISTRATORS', 'f_help_add', 'group'),
			// Global Role permissions for admins
			array('ROLE_ADMIN_FULL', 'a_help_delete'),
		),	
	),	
	

	
);

// Include the UMIF Auto file and everything else will be handled automatically.
include($phpbb_root_path . 'umil/umil_auto.' . $phpEx);

?>