<?php
/**
*
* @package Helpmod
* @version 0.1
* @copyright (c) 2008 Quba (phpBBhelp.pl)
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
*/

/**
* @ignore
*/
define('IN_PHPBB', true);
$phpbb_root_path = (defined('PHPBB_ROOT_PATH')) ? PHPBB_ROOT_PATH : './';
$phpEx = substr(strrchr(__FILE__, '.'), 1);
include($phpbb_root_path . 'common.' . $phpEx);
include($phpbb_root_path . '/includes/functions_helpmod.' . $phpEx);


// Start session management
$user->session_begin();
$auth->acl($user->data);
$user->setup();
$user->add_lang('mods/helpmod');

$id = intval(request_var('id', ''));
$uid = intval(request_var('u', ''));
$post_id = intval(request_var('p', ''));
$topic_id = intval(request_var('t', ''));

switch (request_var('mode', ''))
{
	case 'view':

		$helpmod = new helpmod();
		$helpmod->show_list($uid);

		page_header($user->lang['HELP_LIST']);

		$template->set_filenames(array(
			'body' => 'help_body.html')
		);

		page_footer();
	break;

	case 'details':

		$helpmod = new helpmod();
		$helpmod->show_details($topic_id, $uid);

		$template->set_filenames(array(
			'body' => 'help_body.html')
		);

		page_footer();
	break;

	case 'postdetails':

		$helpmod = new helpmod();
		$helpmod->show_postdetails($post_id);

		$template->set_filenames(array(
			'body' => 'help_body.html')
		);

		page_footer();
	break;

	case 'add':

		$helpmod = new helpmod();
		$helpmod->handle_point_add($post_id);

	break;

	case 'delete':

		$helpmod = new helpmod();
		$helpmod->handle_point_delete($id, $topic_id);

	break;

	default:

		$meta_info = append_sid("{$phpbb_root_path}index.$phpEx", "");
		$message = $user->lang['NO_MODE'] . '<br /><br />' . sprintf($user->lang['RETURN_INDEX'], '<a href="' . append_sid("{$phpbb_root_path}index.$phpEx", "") . '">', '</a>');
		meta_refresh(3, $meta_info);
		trigger_error($message);
		
	break;
}

?>